using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace ColourDemo
{
    public partial class ColourDemoForm : Form
    {
        public ColourDemoForm()
        {
            InitializeComponent();
        }

        protected override void OnPaint(PaintEventArgs e)
        {
            Graphics graphics = e.Graphics;

            // Display rectangle
            Color backColor = Color.FromArgb(255, Color.Blue);
            SolidBrush brush = new SolidBrush(backColor);
            graphics.FillRectangle(brush, 10, 10, 100, 100);

            int alpha = 20;
            Color frontColor = Color.FromArgb(alpha, Color.Red);
            SolidBrush brush1 = new SolidBrush(frontColor);
            graphics.FillRectangle(brush1, 50, 50, 100, 100);

            Font f = this.Font;
            SolidBrush textBrush = new SolidBrush(Color.BlueViolet);
            graphics.DrawString("Demonstrating the use of the alpha channel. Alpha= " + alpha + "  ",f,textBrush,10,200);
        }
    }
}